% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen.R
\name{generate}
\alias{generate}
\title{Compose generators}
\usage{
generate(loop)
}
\arguments{
\item{loop}{A `for` loop expression, where the value
iterated over is another Hedgehog generator.}
}
\description{
Use `generator` with a for loop over the output of another
generator to create a new, more interesting generator.
}
\examples{
gen_squares   <- generate(for (i in gen.int(10)) i^2)
gen_sq_digits <- generate(for (i in gen_squares) {
  gen.c(of = i, gen.element(1:9))
})
}
\seealso{
[gen-monad()] for FP style ways of sequencing
  generators. This function is syntactic sugar over
  `gen.and_then` to make it palatable for R users.
}
