% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprecated.R, R/run_model_define.R
\name{run_models}
\alias{run_model}
\alias{run_model_}
\alias{run_models}
\alias{run_models_}
\title{Run one or more Markov Model}
\usage{
run_models(...)

run_models_(...)

run_model(..., parameters = define_parameters(), init = c(1000L, rep(0L,
  get_state_number(get_states(list(...)[[1]])) - 1)), cycles = 1,
  method = c("life-table", "beginning", "end", "half-cycle"), cost = NULL,
  effect = NULL, state_cycle_limit = NULL, central_strategy = NULL)

run_model_(uneval_strategy_list, parameters, init, cycles, method, cost, effect,
  state_cycle_limit, central_strategy)
}
\arguments{
\item{...}{One or more \code{uneval_model} object.}

\item{parameters}{Optional. An object generated by 
\code{\link{define_parameters}}.}

\item{init}{numeric vector, same length as number of 
model states. Number of individuals in each model state
at the beginning.}

\item{cycles}{positive integer. Number of Markov Cycles 
to compute.}

\item{method}{Counting method.}

\item{cost}{Names or expression to compute cost on the 
cost-effectiveness plane.}

\item{effect}{Names or expression to compute effect on 
the cost-effectiveness plane.}

\item{state_cycle_limit}{Optional expansion limit for 
\code{state_cycle}, see details.}

\item{central_strategy}{The strategy at the center of the
cost-effectiveness plane, for readability.}

\item{uneval_strategy_list}{List of models, only used by 
\code{run_model_} to avoid using \code{...}.}
}
\value{
A list of evaluated models with computed values.
}
\description{
Runs one or more unevaluated Markov Models. When more 
than one model is provided, all models should have the 
same states and state value names.
}
\details{
A usual situation where more than one model needs to be 
run is when comparing different care startegies.

In order to compute comparisons Markov Models must be 
similar (same states and state value names). Thus models 
should only differ through parameters, transition matrix 
cell values and values attached to states (but not state 
value names).

The initial number of individuals in each state and the 
number of cycle will be the same for all models.

\code{state_cycle_limit} can be specified in 3 different 
ways: 1. As a single value: the limit is applied to all 
states in all models. 2. As a named vector (where names 
are state names): the limits are applied to the given 
state names, for all models. 3. As a named list of named 
vectors: the limits are applied to the given state names 
for the given models.
}
\examples{
# running a single model

mod1 <-
  define_strategy(
    transition = define_transition(
      .5, .5,
      .1, .9
    ),
    define_state(
      cost = 543,
      ly = 1
    ),
    define_state(
      cost = 432,
      ly = 1
    )
  )


res <- run_model(
  mod1,
  init = c(100, 0),
  cycles = 2,
  cost = cost,
  effect = ly
)

# running several models
mod2 <-
  define_strategy(
    transition = define_transition(
      .5, .5,
      .1, .9
    ),
    define_state(
      cost = 789,
      ly = 1
    ),
    define_state(
      cost = 456,
      ly = 1
    )
    
  )


res2 <- run_model(
  mod1, mod2,
  init = c(100, 0),
  cycles = 10,
  cost = cost,
  effect = ly
)
}

