% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gho_mortality.R
\name{who-mortality}
\alias{who-mortality}
\alias{get_who_mr_memo}
\alias{get_who_mr}
\title{Use WHO Mortality Rate}
\usage{
get_who_mr_memo(age, sex = NULL, region = NULL, country = NULL,
  year = "latest", local = FALSE)

get_who_mr(age, sex = NULL, region = NULL, country = NULL,
  year = "latest", local = FALSE)
}
\arguments{
\item{age}{age as a continuous variable.}

\item{sex}{sex as \code{"FMLE"}-\code{"MLE"}, \code{0}-\code{1} (male = 0,
female = 1) or \code{1}-\code{2} (male = 1, female = 2).}

\item{region}{Region code. Assumed \code{NULL} if provided along
with \code{country}.}

\item{country}{Country code (see details).}

\item{year}{Use data from that year. Defaults to
\code{"latest"}.}

\item{local}{Fetch mortality data from package cached
data?}
}
\value{
This function should be used within
\code{\link[=define_transition]{define_transition()}} or \code{\link[=define_parameters]{define_parameters()}}.
}
\description{
Returns age and sex-specific mortality probabilities for
a given country.
}
\details{
Locally cached data is used in case of connection
problems, of if \code{local = TRUE}. For memory space reasons
local data is only available for WHO high-income
countries, and only for the latest year.

The results of \code{get_who_mr} are memoised for
\code{options("heemod.memotime")} (default: 1 hour) to
increase resampling performance.
}
\examples{

define_transition(
  C, get_who_mr(age = 50 + markov_cycle, sex = "FMLE", country = "FRA"),
  0, 1
)

}
