\name{Adopted}
\alias{Adopted}
\docType{data}
\title{Adopted Children}
\description{
  Data are a subset from an observational, longitudinal, study on
  adopted children.  Is child's intelligence related to intelligence of
  the biological mother and the intelligence of the adoptive mother?

  The child's intelligence was measured at age 2, 4, 8, and 13 for
  this sample.  How does intelligence change over time, and how are
  these changes related to intelligence of the birth and adoptive mother?
}
\usage{Adopted}
\format{
  A data frame with 62 observations on the following 6 variables.
  \describe{
    \item{\code{AMED}}{adoptive mother's years of education (proxy for her IQ)}
    \item{\code{BMIQ}}{biological mother's score on IQ test}
    \item{\code{Age2IQ}}{IQ of child at age 2}
    \item{\code{Age4IQ}}{IQ of child at age 4}
    \item{\code{Age8IQ}}{IQ of child at age 8}
    \item{\code{Age13IQ}}{IQ of child at age 13}
  }
}
\source{
  Ramsey, F.L. and Schafer, D.W. (2002). \emph{The Statistical Sleuth: A
    Course in Methods of Data Analysis (2nd ed)}, Duxbury.

  This data set is identical to  \code{\link[Sleuth2]{ex1605}} in the \code{Sleuth2}
  package. 
}
\references{
  Friendly, Michael  (2010). HE Plots for Repeated Measures Designs. \emph{Journal of Statistical Software},
  37(4), 1-40. URL \url{http://www.jstatsoft.org/v37/i04/}.

  Skodak, M. and Skeels, H.M. (1949). A Final Follow-up Study of One
  Hundred Adopted Children, \emph{Journal of Genetic Psychology}
  \bold{75}: 85--125.
}
\seealso{
  \code{\link[Sleuth2]{ex1605}}
}
\examples{
\dontshow{
	# allow to work with car 1
	if (packageDescription("car")[["Version"]] < 2) {
		dataEllipse <- data.ellipse
		linearHypothesis <- linear.hypothesis
	}
}
# Treat as multivariate regression problem
Adopted.mod <- lm(cbind(Age2IQ, Age4IQ, Age8IQ, Age13IQ) ~ AMED + BMIQ, data=Adopted)
Adopted.mod

# test overall multivariate regression
linearHypothesis(Adopted.mod, c("AMED","BMIQ"))

# show separate linear regressions
op <- par(mfcol=c(2,4), mar=c(4,4,2,2)+.1)
for (i in 3:6) {
	dataEllipse(as.matrix(Adopted[,c(1,i)]),col="black", levels=0.68, ylim=c(70,140))
	abline(lm(Adopted[,i] ~ Adopted[,1]), col="red", lwd=2)
	dataEllipse(as.matrix(Adopted[,c(2,i)]),col="black", levels=0.68, ylim=c(70,140))
	abline(lm(Adopted[,i] ~ Adopted[,2]), col="red", lwd=2)
	abline(a=0,b=1, lty=1, col="blue")
}
par(op)

# between-S (MMReg) plots
heplot(Adopted.mod, hypotheses=list("Reg"=c("AMED", "BMIQ")),
	main="IQ scores of adopted children: MMReg")

pairs(Adopted.mod, hypotheses=list("Reg"=c("AMED", "BMIQ")))

heplot3d(Adopted.mod, hypotheses=list("Reg"=c("AMED", "BMIQ")),
	col = c("red", "blue", "black", "gray"), wire=FALSE)

# Treat IQ at different ages as a repeated measure factor
# within-S models & plots
Age <- data.frame(Age=ordered(c(2,4,8,13)))
Anova(Adopted.mod, idata=Age, idesign=~Age, test="Roy")

# within-S plots
heplot(Adopted.mod, idata=Age, idesign=~Age, iterm="Age",
	cex=1.25, cex.lab=1.4, fill=c(FALSE, TRUE),
	hypotheses=list("Reg"=c("AMED", "BMIQ"))
	)

}


\keyword{datasets}
