% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colDevs.R
\name{colDevs}
\alias{colDevs}
\title{Calculate column deviations from central values}
\usage{
colDevs(x, group, center = mean, group.var = FALSE, ...)
}
\arguments{
\item{x}{A numeric data frame or matrix.}

\item{group}{A factor (or variable that can be coerced to a factor)
indicating the membership of each observation in \code{x} in one or more
groups. If missing, all the data is treated as a single group.
You can also specify the \code{\link[base]{interaction}} of two or more
factors.}

\item{center}{A function used to center the values (for each group if
\code{group} is specified. The function must take a vector argument and
return a scalar result.}

\item{group.var}{logical. If \code{TRUE}, the \code{group} variable containing factor levels is prepended to the
matrix of deviations.}

\item{\dots}{Arguments passed down}
}
\value{
By default, it returns a numeric matrix containing the deviations from the centering
        function. If \code{levels==TRUE}, it returns a data.frame containing the group factor prepended to the
        matrix of deviations.
}
\description{
\code{colDevs} calculates the column deviations of data values from a
central value (mean, median, etc.), possibly stratified by a grouping
variable.
}
\details{
Conceptually, the function is similar to a column-wise
\code{\link[base]{sweep}}, by group, allowing an arbitrary \code{center}
function.

Non-numeric columns of \code{x} are removed, with a warning.
}
\examples{

data(iris)

Species <- iris$Species
irisdev <- colDevs(iris[,1:4], Species, mean)

irisdev <- colDevs(iris[,1:4], Species, median)
# trimmed mean, using an anonymous function
irisdev <- colDevs(iris[,1:4], Species, function(x) mean(x, trim=0.25))

# include the group factor in output
irisdev <- colDevs(iris[,1:4], Species, group.var = "Species")
head(irisdev)

# no grouping variable: deviations from column grand means
# include all variables (but suppress warning for this doc)
irisdev <- suppressWarnings( colDevs(iris) )

# two-way design
colDevs(Plastic[,1:3], Plastic[,"rate"])
colDevs(Plastic[,1:3], Plastic[,"additive"])
# cell deviations
#' colDevs(Plastic[,1:3], interaction(Plastic[,c("rate", "additive")]))
}
\seealso{
\code{\link[base]{colMeans}} for column means,

\code{\link[base]{sweep}}
}
\author{
Michael Friendly
}
\keyword{manip}
