
\name{hergm-postprocess}

\alias{hergm.postprocess}

\alias{postprocess-hergm}

\alias{postprocess.hergm}

\title{Hierarchical Exponential-Family Random Graph Models: Postprocessing Samples}

\usage{

hergm.postprocess(sample = NULL,
                  burnin = 0, 
                  thinning = 1,
                  relabel = FALSE,
                  name = NULL, 
                  \dots)

}

\description{

If called with the option \code{simulate = TRUE}, the function \code{hergm} returns a sample of networks, otherwise a raw MCMC sample from the posterior.
The function \code{hergm.postprocess} postprocesses samples:
if called with the \code{relabel = FALSE},
\code{hergm.postprocess} extracts information of interest,
otherwise it solves, in addition, the so-called label-switching problem.
The label-switching problem is rooted in the invariance of the likelihood function to permutations of the labels of blocks, and implies that the raw MCMC sample cannot be used to infer to block-dependent entities.
The label-switching problem can be solved in a Bayesian decision-theoretic framework: by defining a loss function and minimizing the posterior expected loss.
Calling \code{hergm.process} minimizes the posterior expected loss using a simple and convenient loss function.
The required computations can be time-consuming when the number of blocks \code{k} is large.

}

\arguments{

\item{sample}{MCMC sample generated by function \code{hergm}.}

\item{burnin}{number of burn-in iterations; if computing is parallel, number of burn-in iterations per processor.}

\item{thinning}{if \code{thinning > 1}, every \code{thinning}-th sample point is used while all others discarded.}

\item{relabel}{if \code{TRUE}, relabel MCMC sample.}

\item{name}{name of project; if \code{output == TRUE}, name of project is used to name output files.}

\item{\dots}{additional arguments, to be passed to lower-level functions in the future.}

}

\value{

\item{ergm_theta}{parameters of \code{ergm-terms}.}

\item{alpha}{scaling parameter of truncated Dirichlet process / stick-breaking prior of parameters of \code{hergm-terms}.} 

\item{eta_mean}{mean parameters of Gaussian base distribution of parameters of \code{hergm-terms}.}

\item{eta_precision}{precision parameters of Gaussian base distribution of parameters of \code{hergm-terms}.}

\item{hergm_theta}{parameters of \code{hergm-terms}.}

\item{p_k}{probabilities of membership to blocks.}

\item{indicator}{indicators of memberships of nodes.}

\item{p_i_k}{probabilities of membership of nodes to blocks.}

\item{prediction}{posterior predictions of statistics.}

}

\seealso{network, hergm.example, hergm, ergm.terms, hergm.terms}

\examples{\dontrun{# Load undirected network with 15 nodes (see ?example)
data(example)

# Generate MCMC sample of size 1,000
mcmc <- hergm(d ~ edges_i, parallel = 1, samplesize = 1000)
# Postprocess MCMC sample of size 1,000
processed_mcmc <- hergm.postprocess(sample = mcmc, burnin = 200)

# Generate MCMC sample of size 20 * 100 = 2,000
mcmc <- hergm(d ~ edges + triangle_ijk, parallel = 20, samplesize = 100)
# Postprocess MCMC sample of size 20 * 100 = 2,000
processed_mcmc <- hergm.postprocess(sample = mcmc, burnin = 20)
}
}

