% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hermite_estimator_univar.R
\name{density.hermite_estimator_univar}
\alias{density.hermite_estimator_univar}
\title{Creates an object summarizing the PDF with associated generic methods 
print and plot.}
\usage{
\method{density}{hermite_estimator_univar}(x, x_lower = NA, x_upper = NA, ...)
}
\arguments{
\item{x}{A hermite_estimator_univar object.}

\item{x_lower}{A numeric value. This value determines the lower limit of 
x values at which to evaluate the density.}

\item{x_upper}{A numeric value. This value determines the upper limit of 
x values at which to evaluate the density.}

\item{...}{Additional arguments for the dens function.}
}
\value{
A hdensity_univar object whose underlying structure is a list 
containing the following components.

x: The points at which the density is calculated.
density_vals: The density values at the points x.
num_obs: The number of observations used to form the Hermite density 
estimates.
N: The number of terms N in the Hermite series estimator.
}
\description{
The hermite_estimator_univar, x must be updated with observations prior to 
the use of the method.
}
