% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/knot.design.R
\name{knot.design}
\alias{knot.design}
\alias{knot_design}
\alias{knotDesign}
\alias{KnotDesign}
\title{Design knot/breakpoint spacing}
\usage{
knot.design(
  rangeval = 0:1,
  nbasis,
  nknots,
  norder = 4,
  extend = FALSE,
  interior = FALSE
)

knot_design(
  rangeval = 0:1,
  nbasis,
  nknots,
  norder = 4,
  extend = FALSE,
  interior = FALSE
)

knotDesign(
  rangeval = 0:1,
  nbasis,
  nknots,
  norder = 4,
  extend = FALSE,
  interior = FALSE
)

KnotDesign(
  rangeval = 0:1,
  nbasis,
  nknots,
  norder = 4,
  extend = FALSE,
  interior = FALSE
)
}
\arguments{
\item{rangeval}{A numeric vector of length 2 defining the
interval over which the functional data object can be
evaulated.  The default value is \code{0:1}.}

\item{nbasis}{An integer specifying the number of
basis functions to construct.  This is closely linked to
the number of knots (\code{nknots}), and
\code{nknots = nbasis - norder}.}

\item{nknots}{The number of *interior* knots.  See Details.}

\item{norder}{An integer specifying the order of the B-splines, which is one higher than their degree.  The default is 4, which corresponds to cubic splines.}

\item{extend}{Should the knots stop at the endpoints specified by \code{rangeval}?  Default is \code{FALSE}. See Details.}

\item{interior}{A logical value specifying whether only interior knots should be returned.  Default is \code{FALSE}.}
}
\value{
An ascending sequence of univarite knot locations.
}
\description{
See Details of \code{\link{bspline}} for additional
information about arguments.
}
\examples{
b = fda::create.bspline.basis(nbasis = 10)
# interior knots only
bknots = b$params
# should match
knots = knot.design(nbasis = 10, interior = TRUE)
all.equal(bknots, knots)
}
