% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare.list.R
\name{prepare.list}
\alias{prepare.list}
\title{Prepare data array for sandwich smooth}
\usage{
\method{prepare}{list}(data, x, splines, m = 2, sparse = TRUE, ...)
}
\arguments{
\item{data}{A list of \code{numeric}, \code{matrix}, or
\code{array} objects.}

\item{x}{A list of values at which to evaluate the basis
functions.  See Examples and Details.}

\item{splines}{A list of spline objects
(\code{hero_bspline} and \code{hero_radspline}).  See
Examples and Details.}

\item{m}{A positive integer indicating order of the difference penalty.}

\item{sparse}{A logical value indicating if the result
should be a sparse version of the
\code{\link[Matrix]{Matrix-class}}.}

\item{...}{Not currently implemented.}
}
\value{
A \code{prepared_list} object.
}
\description{
\code{prepare.list} prepares a list of data for the
sandwich smooth.  The class of each element of
the list must be identical.
The dimensionality of \code{data[[i]]} and
the length of \code{x} must match.  Specifically,
\code{length(dim(data[[i]]))} must equal
\code{length(x)}.     The dimensionality of
\code{data[[i]]} and  the length of \code{splines} must match.
Specifically, \code{length(dim(data[[i]]))} must equal
\code{length(splines)}.      Note: If the splines
are preassembled, these can be passed using the argument
\code{assembled} so that this computation is not reperformed.
}
\details{
This function applies the functions
\code{\link{prepare.numeric}},
\code{\link{prepare.matrix}}, and
\code{\link{prepare.array}} to each element of the list,
so relevant restrictions in the arguments may be
found there.
}
\examples{
# generate and prepare 3d data
set.seed(9)
dat = lapply(1:3, function (i) generate.data3d())
x = dat[[1]]$x
data = lapply(dat, getElement, name = "data3d")
obj = prepare(data, x = x)
h = hero(obj)
}
\references{
Xiao, L. , Li, Y. and Ruppert, D. (2013),
  Fast bivariate P-splines: the sandwich smoother. J. R.
  Stat. Soc. B, 75: 577-599. <doi:10.1111/rssb.12007>
}
\seealso{
\code{\link{prepare.numeric}}, \code{\link{prepare.matrix}},
\code{\link{prepare.array}}
}
\author{
Joshua French.
}
