% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hesim_data.R
\name{create_lines_dt}
\alias{create_lines_dt}
\title{Create a data table of treatment lines}
\usage{
create_lines_dt(strategy_list, strategy_ids = NULL)
}
\arguments{
\item{strategy_list}{A list where each element is a treatment strategy
consisting of a vector of treatments.}

\item{strategy_ids}{A numeric vector denoting the numeric id of each strategy
in \code{strategy_list}.}
}
\value{
Returns a \code{data.table} in tidy format with three columns:
\describe{
\item{strategy_id}{Treatment strategy ids.}
\item{line}{Line of therapy.}
\item{treatment_id}{Treatment ID for treatment used at a given line of therapy within a treatment strategy.}
}
}
\description{
Convert a list of treatment lines for multiple treatment strategies to a
\code{data.table}.
}
\examples{
strategies <- list(c(1, 2, 3),
                  c(1, 2))
create_lines_dt(strategies)
}
