% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/params.R
\name{params_mlogit}
\alias{params_mlogit}
\title{Parameters of a multinomial logit model}
\usage{
params_mlogit(coefs)
}
\arguments{
\item{coefs}{A 3D array of stacked matrices. The number of matrices (i.e.,
the number of slices in the cube) should be equal to \eqn{K-1}. Each
matrix is contains samples of the regression coefficients under sampling uncertainty
corresponding to a particular class. Rows index parameter samples and
columns index coefficients.}
}
\value{
An object of class \code{params_mlogit}, which is a list containing \code{coefs}
and \code{n_samples}, where \code{n_samples} is equal to the number of rows
in each element of \code{coefs}.
}
\description{
Store the parameters of a fitted multinomial logistic
regression model. The model is used to predict probabilities of \eqn{K}
classes.
}
\details{
Multinomial logit models are used to predict the probability of
membership for subject \eqn{i} in each of \eqn{K} classes as a function of covariates:
\deqn{Pr(y_i = c) = \frac{e^{\beta_c x_i}}{\sum_{k=1}^K e^{\beta_k x_i}}}
}
\examples{
params <- params_mlogit(coefs = array(
  c(matrix(c(intercept = 0, treatment = log(.75)), nrow = 1),
    matrix(c(intercept = 0, treatment = log(.8)), nrow = 1)),
  dim = c(1, 2, 2)
)) 
}
