% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/params_mlogit.R
\name{params_mlogit}
\alias{params_mlogit}
\alias{print.params_mlogit}
\title{Parameters of a multinomial logit model}
\usage{
params_mlogit(coefs)
}
\arguments{
\item{coefs}{A 3D array of stacked matrices containing samples of the regression
coefficients under sampling uncertainty. May also be a
list of objects (e.g., data frames) that can be coerced into matrices with
\code{as.matrix()}. Each matrix must have the same number of columns and the
number of matrices must be equal to \eqn{K-1}.}
}
\value{
An object of class \code{params_mlogit}, which is a list containing \code{coefs}
and \code{n_samples}, where \code{n_samples} is equal to the number of rows in each
element of \code{coefs}. The \code{coefs} element is always converted into
a 3D array of stacked matrices.
}
\description{
Store the parameters of a fitted multinomial logistic
regression model. The model is used to predict probabilities of \eqn{K}
classes, which represent the probability of transitioning to particular health
state in a discrete time state transition model. Can be used as an element of a
\code{\link{params_mlogit_list}} to parameterize a \code{\link{CohortDtstmTrans}} object.
}
\details{
Multinomial logit models are used to predict the probability of
membership for subject \eqn{i} in each of \eqn{K} classes as a function of covariates:
\deqn{Pr(y_i = c) = \frac{e^{\beta_c x_i}}{\sum_{k=1}^K e^{\beta_k x_i}}}
}
\examples{
# Consider a sick-sicker model and model transitions from the sick state

## We can instantiate from a list of data frames
params <- params_mlogit(
  coefs = list(
    ### Transition from sick to sicker
    sicker = data.frame(
      intercept = c(-0.33, -.2, -.15),
      treat = c(log(.75), log(.8), log(.9))
    ),
    
   ### Transition from sick to death
    death = data.frame(
      intercept = c(-1, -1.2, -.5),
      treat = c(log(.6), log(.65), log(.55))
    )
  )
)
summary(params)
params

## We can also instantiate from an array
coefs_sicker <- data.frame(
  intercept = c(-0.33, -.2, -.15),
  treat = c(log(.75), log(.8), log(.9))
)
coefs_death <- data.frame(
  intercept = c(-1, -1.2, -.5),
  treat = c(log(.6), log(.65), log(.55))
)

params2 <- params_mlogit(
  coefs <- array(
    data = c(as.matrix(coefs_sicker),
             as.matrix(coefs_death)),
    dim = c(3, 2, 2),
    dimnames = list(NULL, c("intercept", "treat"), c("sicker", "death"))
  )
)
params2
}
\seealso{
\code{\link[=summary.params_mlogit]{summary.params_mlogit()}}, \code{\link[=params_mlogit_list]{params_mlogit_list()}}, \code{\link{CohortDtstmTrans}}
}
