% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/precedence_matrix_absolute.R
\name{precedence_matrix}
\alias{precedence_matrix}
\title{Precedence Matrix}
\usage{
precedence_matrix(
  eventlog,
  type = c("absolute", "relative", "relative-antecedent", "relative-consequent",
    "relative-case")
)
}
\arguments{
\item{eventlog}{The event log object to be used}

\item{type}{The type of precedence matrix, which can be absolulte, relative, relative-antecedent or relative-consequent. Absolute will return
a matrix with absolute frequencies, relative will return global relative frequencies for all antecedent-consequent pairs.
Relative-antecedent will return relative frequencies within each antecendent, i.e. showing the relative proportion of consequents within each antecedent.
Relative-consequent will do the reverse.}
}
\description{
Construct a precedence matrix, showing how activities are followed by each other.
This is a performance improved variant of \code{\link[processmapR]{precedence_matrix}}
in the processmapR package.
}
\examples{
m <- precedence_matrix(hospital_multi_perspective, type = "absolute")
print(m)
as.matrix(m)

}
