\name{HHRender}
\alias{HHRender}
\title{Render Hilbert spectrogram}
\description{
This function prepares results from the Hilbert transform of EMD or EEMD results for display using \code{\link{HHGramImage}}.
}
\usage{
HHRender(hres, dt, dfreq, time.span = NULL, freq.span = NULL, scaling = "none", 
    combine.imfs = TRUE, verbose = TRUE)  
}
\arguments{
\item{hres}{This is the output generated by \code{\link{Sig2IMF}}, \code{\link{EEMDCompile}}, \code{\link{EEMDResift}}}, or \code{\link{CEEMD}}.
\item{dt}{Time resolution of spectrogram.  Must be greater than the sample rate of the time series to avoid gaps.}
\item{dfreq}{Frequency resolution of spectrogram.}
\item{time.span}{Time span to render spectrogram over; \code{NULL} means over the whole time series.}
\item{freq.span}{Frequency span to include in spectrogram; \code{NULL} means render all the frequencies in the time series}
\item{scaling}{If \code{"log"}, render a log frequency spectrogram.  Defaults to \code{"none"} (linear).}
\item{combine.imfs}{If \code{TRUE}, add the spectra for all IMFS together in one ensemble Hilbert spectrogram, if \code{FALSE}, keep separate so you can investigate individual IMFs in \code{\link{HHGramImage}}.}
\item{verbose}{If \code{TRUE}, print progress messages.}
}
\details{
\code{HHRender} processes Hilbert spectral data prior to displaying with \code{\link{HHGramImage}}.
\code{HHRender} returns the ensemble Hilbert spectrogram if \code{combine.imfs = TRUE}, otherwise it returns an IMF-by-IMF Hilbert spectrogram of dimensions \code{[time, freq, imf]}.
The user can then choose which IMFs to plot when he or she calls \code{\link{HHGramImage}}, but this makes \code{\link{HHGramImage}} run about 40x slower on my machine.
The trade off is in speed versus flexibility for \code{\link{HHGramImage}}; the \code{combine.imfs} option does not affect \code{HHRender} very much.
}

\note{The \code{HHRender} function also keeps track of which trial contributes what data to the spectrogram.
For the EMD, this does not make much sense, because there is only one trial.
However, when \code{HHRender} is run on EEMD results, it remembers which time/frequency bin gets data from each trial.
This is a way to distinguish between noise and signal in data:  signal is where multiple trials contribute data to the same time/frequency bin,
noise is where only one (or a couple) of trials contribute data.
See options for \code{\link{HHGramImage}} for ways to plot data based on signal stability.}
\value{ 
\item{hgram}{A data structure containing the spectrogram image and other information required by \code{\link{HHGramImage}}.}
}

\author{Daniel Bowman \email{daniel.bowman@unc.edu}}

\seealso{
\code{\link{EEMDCompile}}, \code{\link{HHGramImage}}
}
\examples{
data(PortFosterEvent)

trials <- 10
nimf <- 10
noise.amp <- 6.4e-07
trials.dir <- "test"

set.seed(628)
#Run EEMD (this may take some time)
\dontrun{EEMD(sig, tt, noise.amp, trials, nimf, noise.amp, trials.dir <- trials.dir)}

#Compile the results
\dontrun{EEMD.result <- EEMDCompile(trials.dir, trials, nimf)}

#Calculate spectrogram
dt <- 0.1
dfreq <- 0.1

\dontrun{hgram <- HHRender(EEMD.result, dt, dfreq)}

#Plot spectrogram 
time.span <- c(5, 10)
freq.span <- c(0, 25)
amp.span <- c(1e-6, 2.5e-5)
\dontrun{HHGramImage(hgram, time.span = time.span, 
    freq.span = freq.span, amp.span = amp.span)}
}
\keyword{ts}
\keyword{hplot}
