% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visuals.R
\name{plot_outlier_distribution}
\alias{plot_outlier_distribution}
\title{Plot the outlying elements of a HierarchicalSet object}
\usage{
plot_outlier_distribution(x, alpha = 0.3)
}
\arguments{
\item{x}{A HierarchicalSet object}

\item{alpha}{The transparancy of the dots}
}
\value{
This function is called for its side effects
}
\description{
This function creates a scatter plot showing each outlying element as a
function of the number of sets it is present in and the number of times it
is outlying.
}
\examples{
data('twitter')

twitSet <- create_hierarchy(twitter)
plot_outlier_distribution(twitSet)

}
\seealso{
\code{\link{outlying_elements}} for extracting outlying element
information from a HierarchicalSet object
}

