% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_handling.R
\name{aggregateQuotes}
\alias{aggregateQuotes}
\title{Aggregate a data.table or xts object containing quote data}
\usage{
aggregateQuotes(
  qData,
  on = "minutes",
  k = 5,
  marketOpen = "09:30:00",
  marketClose = "16:00:00",
  tz = "GMT"
)
}
\arguments{
\item{qData}{data.table or xts object to be aggregated, containing the intraday quote data of a stock for one day.}

\item{on}{character, indicating the time scale in which "k" is expressed. Possible values are: "secs", "seconds", "mins", "minutes","hours".
xts object to the 5 minute frequency, set k=5 and on = "minutes".}

\item{k}{positive integer, indicating the number of periods to aggregate over. E.g. to aggregate an
object to the 5 minute frequency set k = 5 and on = "minutes".}

\item{marketOpen}{the market opening time, by default: marketOpen = "09:30:00".}

\item{marketClose}{the market closing time, by default: marketClose = "16:00:00".}

\item{tz}{time zone used, by default: tz = "GMT".}
}
\value{
a data.table or xts object containing the aggregated time series.

A data.table or an xts object containing the aggregated quote data.
}
\description{
Function returns a data.table or xts object containing the aggregated quote data with columns "SYMBOL", "EX", "BID","BIDSIZ","OFR","OFRSIZ". 
See \code{\link{sampleQData}} for an example of the argument qData.
}
\details{
The output "BID" and "OFR" columns are constructed using previous tick aggregation.

The variables "BIDSIZ" and "OFRSIZ" are aggregated by taking the sum of the respective inputs over each interval.

The timestamps of the new time series are the closing times of the intervals. 

Please note: Returned objects always contain the first observation (i.e. opening quotes,...).
}
\examples{
# aggregate quote data to the 30 second frequency
qDataAggregated <- aggregateQuotes(sampleQData, on = "seconds", k = 30)
head(qDataAggregated)
}
\author{
Jonathan Cornelissen, Kris Boudt and Onno Kleen
}
\keyword{data}
\keyword{manipulation}
