% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hilbertProjection.R
\name{hilbertProjection}
\alias{hilbertProjection}
\title{Project a Cut Reference Matrix to a Different Space through an Hilbert Index}
\usage{
hilbertProjection(hc, target = 2)
}
\arguments{
\item{hc}{the hilbert index returned by \code{\link{do.hilbert}}}

\item{target}{the number of dimensions in the target space (defaults to 2)}
}
\value{
a matrix with \code{target} columns, corresponding to
the projection of each Hilbert index to \code{target} dimensions
}
\description{
Starting from a Hilbert Index generated in a high dimensional space, returns a set of coordinates
in a new (lower) dimensional space
}
\details{
Based on the maximum index and the targeted number of dimensions the number of target bins is computed and used
to generate a reference matrix and a reference index. The reference matrix is returned, ordered by the reference index.
}
\examples{
# generate a random matrix
ncols <- 5
mat <- matrix(rnorm(ncols*5000),ncol=ncols)
dimnames(mat)[[2]] <- LETTERS[seq(ncols)]

# generate 4 bins with a minimum bin size of 5
horder <- 4
cuts <- make.cut(mat,n=horder+1,count.lim=5)

# Generate the cuts and compute the Hilbert index
cut.mat <- do.cut(mat,cuts,type='fixed')
hc <- do.hilbert(cut.mat,horder)
chc <- table(hc)
idx <- as.numeric(names(chc))

# project the matrix to 2 dimensions
proj <- hilbertProjection(hc)

# visualize the result
img <- matrix(0,ncol=max(proj[,2])+1,nrow = max(proj[,1])+1)
img[proj[idx,]+1] <- chc
image(img)
}
\author{
Marilisa Neri

Yann Abraham

John Skilling (for the original \code{C} function)
}
