% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{make_aircraft}
\alias{make_aircraft}
\title{Make aircraft data from minimum dataset}
\usage{
make_aircraft(ac = NA, sound_kph = mach_kph, warn = TRUE)
}
\arguments{
\item{ac}{Dataframe containing the minimum fields, or NA (default)}

\item{sound_kph}{Speed of sound used to convert from Mach to kph, default
\code{mach_kph}=1062 at a suitable altitude.}

\item{warn}{Warn if no \code{ac} supplied, so default set is used. Default TRUE.}
}
\value{
Dataframe with at least 11 variables describing the performance of one or
     more aircraft
}
\description{
\code{make_aircraft} ensures a minimum set of variables describing aircraft
}
\details{
This function provides a test set of aircraft if necessary and adds variables
to a minimal set of data to give all the information that will be needed.

This minimal set needs to have the following fields:

\itemize{
  \item \code{id, type}: a very short, and longer text identifier for this aircraft
  \item \code{over_sea_M, over_land_M}: the eponymous two speeds, given as a Mach number
  \item \code{accel_Mpm}: acceleration in Mach per minute between these two
  \item \code{arrdep_kph}: the speed on arrival and departure from airports, given in km per hour
  \item \code{range_km}: range in km
}

An attribute is set to help keep track of where the aircraft data came from
(and whether a new cache is needed). If the \code{aircraftSet} attribute of
the \code{ac} parameter is not set, the set is treated as 'disposable'.


For more details see the help vignette:
\code{vignette("SupersonicRouting", package = "himach")}
}
\examples{
# do minimal version
ac <- make_aircraft()

# on-the-fly example
ac <- data.frame(id = "test", type = "test aircraft",
                 over_sea_M = 2.0, over_land_M = 0.9, accel_Mpm = 0.2,
                 arrdep_kph = 300, range_km = 6000, stringsAsFactors=FALSE)
ac <- make_aircraft(ac)

\dontrun{
# example for your own data
aircraft <- utils::read.csv("data/aircraft.csv", stringsAsFactors = FALSE)
aircraft <- make_aircraft(aircraft)
# strongly recommended to record the file name for later reference
attr(aircraft, "aircraftSet") <- "aircraft.csv"
}

}
