#' @title Plot tau
#' @export
#' @family plot
#' @description Plot the tau parameter of a fitted hierarchical model.
#' @return A `ggplot` object
#' @param mcmc Data frame of posterior samples generated by
#'   [hb_mcmc_hierarchical()].
#' @examples
#' data <- hb_sim_independent(n_continuous = 2)$data
#' mcmc <- hb_mcmc_hierarchical(
#'   data,
#'   n_chains = 1,
#'   n_adapt = 100,
#'   n_warmup = 100,
#'   n_iterations = 200
#' )
#' hb_plot_tau(mcmc = mcmc)
hb_plot_tau <- function(mcmc) {
  true(is.data.frame(mcmc))
  true(
    "tau" %in% colnames(mcmc),
    message = "tau not found. hb_plot_tau() requires the hierarchical model."
  )
  ggplot2::ggplot(mcmc) +
    ggplot2::geom_histogram(
      ggplot2::aes(x = tau, y = ..density..),
      bins = 30
    ) +
    ggplot2::theme_gray(20)
}
