% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/hit.R
\name{hit}
\alias{hit}
\title{Hierarchical Inference Testing}
\usage{
hit(x, y, hierarchy, B = 50, p.samp1 = 0.5, lambda.opt = c("lambda.1se",
  "lambda.min"), nfolds = 10, gamma = seq(0.05, 0.99, length.out = 100),
  max.p.esti = 1, mc.cores = 1L, trace = FALSE, ...)
}
\arguments{
\item{x}{Design matrix of dimension \code{n * p}, without intercept.
Variables not part of the dendrogram are added to the HO-model, see Details
below.}

\item{y}{Quantitative response variable dimension \code{n}.}

\item{hierarchy}{Object of class \code{\link{as.hierarchy}}. Must include all
variables of \code{x} which should be tested.}

\item{B}{Number of sample-splits.}

\item{p.samp1}{Fraction of data used for the LASSO. The ANOVA uses
\code{1 - p.samp1}.}

\item{lambda.opt}{Criterion for optimum selection of cross validated lasso.
Either "lambda.1se" (default) or "lambda.min". See
\code{\link[glmnet]{cv.glmnet}} for more details.}

\item{nfolds}{Number of folds (default is 10), see
\code{\link[glmnet]{cv.glmnet}} for more details.}

\item{gamma}{Vector of gamma-values.}

\item{max.p.esti}{Maximum alpha level. All p-values above this value are set
to one. Small \code{max.p.esti} values reduce computing time.}

\item{mc.cores}{Number of cores for parallelising. Theoretical maximum is
'B'. For details see \code{\link[parallel]{mclapply}}.}

\item{trace}{If TRUE it prints current status of the program.}

\item{...}{Additional arguments for \code{\link[glmnet]{cv.glmnet}}.}
}
\description{
Hierarchical inference testing for linear models with
high-dimensional and/or correlated covariates by repeated sample splitting.
}
\details{
The H0-model contains variables, with are not tested, like
experimental-design variables. These variables are not penalised in the
LASSO model selection and are always include in the reduced ANOVA model.
}
\examples{
set.seed(123)
n <- 80
p <- 90
# x with correlated columns
corMat <- toeplitz((p:1/p)^3)
corMatQ <- chol(corMat)
x <- matrix(rnorm(n * p), nrow = n) \%*\% corMatQ
colnames(x) <- paste0("x", 1:p)
# y
y <- x[, c(3, 5, 73)] \%*\% c(2, 5, 3) + rnorm(n)
# clustering
hc <- hclust(dist(t(x)))
# HIT (run time > 5 sec)
\dontrun{
out <- hit(x, y, hc)
summary(out)
}
}
\references{
Mandozzi, J. and Buehlmann, P. (2013). \emph{Hierarchical testing
in the high-dimensional setting with correlated variables}. To appear in the
Journal of the American Statistical Association. Preprint arXiv:1312.5556
}

