% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eplet-MHC-I.R
\name{CalEpletMHCI}
\alias{CalEpletMHCI}
\title{Calculate class I HLA eplet mismatch}
\usage{
CalEpletMHCI(dat_in, ver = 3)
}
\arguments{
\item{dat_in}{A dataframe of recipient and donor's high resolution MHC I data. Each recipient and donor pair are linked by are the “pair_id” column and differentiated by the “subject_type” column.}

\item{ver}{Version number of HLAMatchMaker based eplet reference table to use.}
}
\value{
A list of data tables.
- `single_detail`: single molecule class I MHC eplet mismatch table, including mismatched eplet names and the count of eplets mismatched at each allele.
- `overall_count`: original input data appended with total count of mismatched eplets.
}
\description{
Use high resolution HLA(Human Leukocyte Antigen) class I data to calculate class I eplet mismatch for a population of donors and recipients. Mismatch is calculated using logic from 'HLAMatchMaker', developed by Rene Dusquesnoy. Current reference tables supported are 'HLAMatchMaker' v2 and v3.
}
\examples{
dat<-read.csv(system.file("extdata/example","MHC_I_test.csv",package="hlaR"),sep=",",header=TRUE)
re <- CalEpletMHCI(dat_in = dat, ver = 3)
}
