% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correlations.R
\name{rat_quad}
\alias{rat_quad}
\title{Rational Quadratic correlation function}
\usage{
rat_quad(x, xp, hp)
}
\arguments{
\item{x}{A data.frame of rows corresponding to position vectors}

\item{xp}{A data.frame of rows corresponding to position vectors}

\item{hp}{The hyperparameters alpha (exponent and scale) and theta (correlation length)}
}
\value{
The rational quadratic correlation between x and xp.
}
\description{
For points \code{x}, \code{xp}, and a pair of hyperparameters \code{alpha} and \code{theta},
gives the rational quadratic correlation between the two points.
}
\details{
This correlation function, for d = |x-x'|, has the form
\eqn{(1+d^2/(2\alpha\theta^2))^{-\alpha}}, and can be seen as a superposition of exponential-squared
correlation functions.
}
\examples{
rat_quad(data.frame(a=1), data.frame(a=2), list(alpha = 1.5, theta = 0.1))
#> 0.004970797
rat_quad(data.frame(a=1,b=2,c=-1),data.frame(a=1.5,b=2.9,c=-0.7), list(alpha = 1.5, theta = 0.2))
#> 0.02904466
}
\references{
Rasmussen & Williams (2005) <ISBN: 9780262182539>
}
