% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnosticplots.R
\name{space_removed}
\alias{space_removed}
\title{Space Removal Diagnostics}
\usage{
space_removed(
  ems,
  targets,
  ppd = 10,
  u_mod = seq(0.8, 1.2, by = 0.1),
  intervals = seq(0, 10, length.out = 200),
  modified = "obs",
  maxpoints = 50000
)
}
\arguments{
\item{ems}{The \code{\link{Emulator}} objects.}

\item{targets}{The corresponding targets to match to.}

\item{ppd}{The number of points per input dimension to sample at.}

\item{u_mod}{The proportional values by which to inflate/deflate the relevant statistic.}

\item{intervals}{The interval values of the implausibility cutoff at which to evaluate.}

\item{modified}{The statistic to modify: obs, disc, var or hp (see above)}

\item{maxpoints}{The maximum number of points to evaluate at}
}
\value{
A ggplot object
}
\description{
Finds the proportion of space removed as a function of implausibility cut-off and of one of
structural discrepancy, emulator variance, or correlation hyperparameter(s).
}
\details{
The reduction in space is found by evaluating a p^d regular grid, where p is chosen by
\code{ppd} and d is the dimension of the input space. Larger values of p will give a more
accurate reflection of the space removed, at a corresponding computational cost. For the
purpose of quick-and-dirty diagnostics, \code{ppd = 5} is sufficient: the default is 10.

The parameter \code{modified} can be one of three strings: \code{'obs'} corresponding
to observation uncertainty; \code{'disc'} corresponding to internal and external
discrepancy (as given in \code{Emulator$disc}); \code{'var'} corresponding to global
emulator variance (as given by \code{Emulator$u_sigma}), and \code{'hp'} corresponding to
the hyperparameters of the emulator correlation structure. In the first case, the
implausibilities are recalculated for each inflation value; in the other two cases the
emulators are retrained. For this reason, the \code{'var'} and \code{'hp'} options are
computationally more intensive. The default is \code{'obs'}.

The inflationary/deflationary values are chosen by \code{u_mod}: the default is to take
80\%, 90\%, 100\%, 110\%, and 120\% of the original value as the variation. The proportion of
points deemed non-implausible is checked at a set of implausibility cutoffs defined by
\code{intervals}, and a plot is returned showing the relevant data.
}
\examples{
 space_removed(SIREmulators$ems, SIREmulators$targets, ppd = 5)
 space_removed(SIREmulators$ems$nS, SIREmulators$targets,
  ppd = 5, u_mod = seq(0.75, 1.25, by = 0.25), intervals = seq(2, 6, by = 0.1))
}
\seealso{
\code{\link{space_removal}} for a numeric representation of space removed.

Other visualisation tools: 
\code{\link{behaviour_plot}()},
\code{\link{diagnostic_wrap}()},
\code{\link{effect_strength}()},
\code{\link{emulator_plot}()},
\code{\link{hit_by_wave}()},
\code{\link{output_plot}()},
\code{\link{plot_actives}()},
\code{\link{plot_lattice}()},
\code{\link{plot_wrap}()},
\code{\link{simulator_plot}()},
\code{\link{validation_pairs}()},
\code{\link{wave_dependencies}()},
\code{\link{wave_points}()},
\code{\link{wave_values}()}
}
\concept{visualisation tools}
