% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hurricanes.R
\name{get_hurricanes}
\alias{get_hurricanes}
\title{Download and plot essential climate data}
\usage{
get_hurricanes(use_cache = TRUE, write_cache = getOption("hs_write_cache"))
}
\arguments{
\item{use_cache}{(boolean) Return cached data if available, defaults to TRUE. Use FALSE to fetch updated data.}

\item{write_cache}{(boolean) Write data to cache, defaults to FALSE. Use TRUE to write data to cache for later use. Can also be set using options(hs_write_cache=TRUE)}
}
\value{
Invisibly returns a tibble with the annual HURDAT hurricane data since 1851
}
\description{
Retrieves Atlantic basin hurricane data since 1851 from National Oceanic and Atmospheric Administration
HURDAT Atlantic Hurricane Database Re-analysis Project.
\url{https://www.aoml.noaa.gov/hrd/hurdat/Data_Storm.html}
}
\details{
\code{get_hurricanes} invisibly returns a tibble with NOAA's annual North Atlantic revised HURDAT hurricane data since 1851.
The returned object includes Year, and number of named storms, hurricanes, major hurricanes (S-S scale 3-5), Accumulated Cyclone Energy (ACE), and U.S. hurricane strikes.

ACE is an index that combines the number of systems, how long they existed and how intense they became. It is calculated by squaring the maximum sustained surface wind in the system every six hours that the cyclone is a Named Storm and summing it up for the season. Please refer to above website for details.
}
\examples{
\donttest{
# Fetch from cache if available:
hurricanes <- get_hurricanes()
#
# Force cache refresh:
hurricanes <- get_hurricanes(use_cache=FALSE)
#
# Review cache contents and last update dates:
hockeystick_cache_details()
#
# Plot output using package's built-in ggplot2 settings
plot_hurricanes(hurricanes) }

}
\references{
HURDAT North Atlantic Hurricane Database Re-analysis Project, Hurricane Research Division, NOAA \url{https://www.aoml.noaa.gov/hrd/hurdat/Data_Storm.html}.

Data from: \url{https://www.aoml.noaa.gov/hrd/hurdat/comparison_table.html}

\url{https://en.wikipedia.org/wiki/Accumulated_cyclone_energy}
}
\author{
Hernando Cortina, \email{hch@alum.mit.edu}
}
