% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kormean.R
\name{kormean}
\alias{kormean}
\title{Take the Mean of two Correlation Matrices}
\usage{
kormean(x, y, xn = NA, yn = NA)
}
\arguments{
\item{x}{a correlation matrix}

\item{y}{a correlation matrix}

\item{xn}{numeric value (optionally) the number of observations for correlation matrix given in x}

\item{yn}{numeric value(optionally) the number of observations for correlation matrix given in y}
}
\value{
the mean correlations of both matrices as a matrix object
}
\description{
This function takes the mean of two correlation matrices using the Fisher-Z transformation of the coefficients in both matrices.
}
\details{
this function uses the numerical values given in parameters \code{xn} and \code{yn} to compute the weighted mean of the Fisher-Z transformed coefficients in both correlation matrices. If either parameter \code{xn} or \code{yn} is not assigned a numerical value, the unweighted mean of both matrices is computed.
}
\examples{
## Correlation matrix for overall ASIT norm sample
data(AIST_2005_F_1270) # female sub-sample
data(AIST_2005_M_1226) # male sub-sample 
kormean(x=AIST_2005_F_1270,y=AIST_2005_M_1226,xn=1270,yn=1226)
}
\keyword{misc}
