% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/con_oneletter_holland.R
\name{con_oneletter_holland}
\alias{con_oneletter_holland}
\title{Congruence Index according to Holland (1963)}
\usage{
con_oneletter_holland(a, b, hexadist = FALSE, letter = 1)
}
\arguments{
\item{a}{a character vector with person Holland codes.}

\item{b}{a character vector with environment Holland codes.}

\item{hexadist}{logical with default set to \code{hexadist = FALSE}. If set to \code{hexadist = TRUE} the spacial distances in the hexagon are considered for the calculation of the first letter congruence.}

\item{letter}{a integer indicating the position of the letter to be used.}
}
\value{
a numeric with value for congruence.
}
\description{
The function computes the one letter congruence index according to Holland (1963).
}
\details{
The function finds the congruence according to Holland (1963) between the Holland codes given in argument a, which is the person code, and argument b, which is the environment code. The Index is based on one letter from the Holland code, which is, according to Holland (1963) typically the first letter. But this can be changed to using any of the six letters, see argument \code{letter}. The degree of congruence is output as distance. This means, for example, that a value of '0' is the result for a perfect fit ! The function offers via the argument \code{hexadist} the extension to consider the spatial distance of the six dimensions in the hexagon for the calculation of the congruence (cf. Bowles, S. M., & Tunick, R. H. 2008).
}
\examples{
con_oneletter_holland(a="RIASEC",b="AIRCES")
con_oneletter_holland(a="RIASEC",b="AIRCES",hexadist=TRUE)
con_oneletter_holland(a="RIASEC",b="AIRCES",letter=2)
con_oneletter_holland(a="RIASEC",b="AIRCES",letter=6)
}
\references{
Holland, J.L. (1963). Explorations of a theory of vocational choice and achievement: II. A four-year prediction study. \emph{Psychological Reports, 12}, 547–594

Bowles, S. M. & Tunick, R. H. (2008). \emph{Is Congruence Dead? An Examination of the Correlation Between Holland’s Congruence and Job Satisfaction Using Improved Methodology.} Morgantown, West Virginia: West Virginia University.
}
\keyword{congruence}
