% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/homomorpheR.R
\docType{package}
\name{homomorpheR}
\alias{homomorpheR}
\alias{homomorpheR-package}
\title{homomorpheR: Homomorphic computations in R}
\description{
\code{homomorpheR} is a start at a rudimentary package for
homomorphic computations in R. The goal is to collect homomorphic
encryption schemes in this package for privacy-preserving
distributed computations; for example, applications of the sort
immplemented in package \code{distcomp}.
}
\details{
At the moment, only one scheme is implemented, the Paillier
scheme. The current implementation makes no pretense at efficiency
and also uses direct translations of other implementations,
particularly the one in Javascript.

For a quick overview of the features, read the
\code{\link{homomorpheR}} vignette by running
\code{vignette("homomorpheR")}.
}
\examples{
keys <- PaillierKeyPair$new(1024) # Generate new key pair
encryptAndDecrypt <- function(x) keys$getPrivateKey()$decrypt(keys$pubkey$encrypt(x))
a <- gmp::as.bigz(1273849)
identical(a + 10L, encryptAndDecrypt(a+10L))
x <- lapply(1:100, function(x) random.bigz(nBits = 512))
edx <- lapply(x, encryptAndDecrypt)
identical(x, edx)
}
\references{
\url{https://en.wikipedia.org/wiki/Homomorphic_encryption}

\url{https://mhe.github.io/jspaillier/}
}

