% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reportingheterogeneity.R
\name{standardizeCoef}
\alias{standardizeCoef}
\alias{standardiseCoef}
\alias{disabilityWeights}
\title{Standardization of the coefficients}
\usage{
standardizeCoef(model, ordered = TRUE, plotf = FALSE,
  plotpval = FALSE, mar = c(15, 4, 1, 1), oma = c(0, 0, 0, 0),
  YLab = "Disability weight", YLab.cex = 1.1, namesf = identity, ...)

standardiseCoef(model, ordered = TRUE, plotf = FALSE,
  plotpval = FALSE, mar = c(15, 4, 1, 1), oma = c(0, 0, 0, 0),
  YLab = "Disability weight", YLab.cex = 1.1, namesf = identity, ...)

disabilityWeights(model, ordered = TRUE, plotf = FALSE,
  plotpval = FALSE, mar = c(15, 4, 1, 1), oma = c(0, 0, 0, 0),
  YLab = "Disability weight", YLab.cex = 1.1, namesf = identity, ...)
}
\arguments{
\item{model}{a fitted \code{hopit} model.}

\item{ordered}{a logical indicating whether to sort the disability weights.}

\item{plotf}{a logical indicating whether to plot the results.}

\item{plotpval}{a logical indicating whether to plot the p-values.}

\item{mar, oma}{graphic parameters, see \code{\link{par}}.}

\item{YLab, YLab.cex}{a label of the y-axis and it's size.}

\item{namesf}{a vector of the names of coefficients or one argument function that modifies the names of coefficients.}

\item{...}{arguments passed to \code{\link{boxplot}}.}
}
\value{
a vector with standardized coefficients.
}
\description{
Calculate standardized the coefficients (e.g. disability weights for the health variables) using
the predicted latent measure obtained from the model.\cr
In the self-rated health example the standardized coefficients are called disability weights \insertCite{Jurges2007;textual}{hopit}
and are calculated for each health variable to provide information about the impact of a specific health measure on the latent index
(see \code{\link{latentIndex}}). The disability weight for a health variable is equal to the ratio of the corresponding health coefficient
and the difference between the lowest and the highest values of the predicted latent health. In other words, the disability weight reduces
the latent index by some given amount or percentage (i.e., the latent index of every individual is reduced by the same amount if the person had a heart attack or other
heart problems)\insertCite{Jurges2007}{hopit}.
}
\examples{
# DATA
data(healthsurvey)

# the order of response levels decreases from the best health to
# the worst health; hence the hopit() parameter decreasing.levels
# is set to TRUE
levels(healthsurvey$health)

# Example 1 ---------------------

# fit a model
model1 <- hopit(latent.formula = health ~ hypertension + high_cholesterol +
                heart_attack_or_stroke + poor_mobility + very_poor_grip +
                depression + respiratory_problems +
                IADL_problems + obese + diabetes + other_diseases,
              thresh.formula = ~ sex + ageclass + country,
              decreasing.levels = TRUE,
              control = list(trace = FALSE),
              data = healthsurvey)

# a function that modifies the coefficient names.
txtfun <- function(x) gsub('_',' ',substr(x,1,nchar(x)-3))

# calculate and plot the disability weights
sc <- standardizeCoef(model1, plotf = TRUE, namesf = txtfun)
sc
}
\references{
\insertRef{Jurges2007}{hopit}\cr\cr
\insertRef{OKSUZYAN2019}{hopit}
}
\seealso{
\code{\link{latentIndex}}, \code{\link{getCutPoints}}, \code{\link{getLevels}}, \code{\link{hopit}}.
}
\author{
Maciej J. Danko
}
