% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SWF.R
\name{DataToSWF}
\alias{DataToSWF}
\title{Convertor from a dataframe to Standart Workload Format}
\usage{
DataToSWF(Frame, filename = "output.swf")
}
\arguments{
\item{Frame}{A dataframe containing the variables needed by ToSWF function}

\item{filename}{The file to store the converted workload (output.swf by default)}
}
\value{
Nothing is returned, but a file is created in the current working directory
(with default name output.swf) containing the converted data.
}
\description{
Note that this is only a wrapper for the ToSWF command with a dataframe
argument. It needs a correctly built dataframe and converts it to a Standart Workload
Format used to share the logfiles of High Performance Clusters
}
\details{
The Standart Workload Format is a single format to store and exchange
high performance cluster logs, that is used in Parallel Workload Archive.
See references for current standard. The SWF format may contain additional
data, but in this package only the 1st to 5th fields are used. One may also
need to manually fill in the header of the file in order to completely
prepare the resulting SWF file.
}
\examples{
\dontrun{
data(HPC_KRC)
tmp=data.frame(T=HPC_KRC$interarrival, S=HPC_KRC$service, N=HPC_KRC$cores_used, D=HPC_KRC$delay)
DataToSWF(tmp)
}
}
\references{
Feitelson, D.G. and Tsafrir, D. and Krakov D. 2012 Experience with the Parallel Workloads Archive. Technical Report 2012-6, School of Computer Science and Engineering, the Hebrew University April, 2012, Jerusalem, Israel

https://www.cs.huji.ac.il/labs/parallel/workload/swf.html
}
