% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/powercalc.R
\name{pwr.normtest}
\alias{pwr.normtest}
\title{Probability under alternative hypothesis (power)}
\usage{
pwr.normtest(R, n, betaSE, lambda, pos, weights = 1, alpha = 0.01)
}
\arguments{
\item{R}{(p x p) matrix containing theoretical correlation between SNP pairs}

\item{n}{sample size}

\item{betaSE}{effect size relative to residual standard deviation}

\item{lambda}{shrinkage parameter}

\item{pos}{vector (LEN nqtl) of SNP indices for assumed QTL positions}

\item{weights}{weights vector (LEN p) of SNP-specific weights or scalar if weights
are equal for all SNPs; default value 1}

\item{alpha}{type-I error level; default value 0.01}
}
\value{
\describe{
  \item{\code{result}}{mean power at selected QTL positions}
  \item{\code{h2.le}}{QTL heritability under linkage-equilibrium assumption}
  \item{\code{h2.ld}}{QTL heritability under linkage-disequilibrium
    assumption}
}
}
\description{
Calculation of power is based on normal distribution.
 At each selected QTL position, the probability of the corresponding
 regression coefficient being different from zero is calculated using a
 t-like test statistic which has normal distribution with mean
 \code{E(beta_k)/sqrt{Var(beta_k)}}
 and variance 1. Under the null hypothesis \code{beta_k = 0},
 \code{E(beta_k) = 0}.
 Then, the mean value is returned as power.
}
\examples{
  ### correlation matrix (should depend on sire haplotypes)
  R <- AR1(100, rho = 0.1)
  ### positions of putative QTL signals
  pos <- c(14, 75)
  ### power at given sample size and other parameters
  pwr.normtest(R, 100, 0.35, 1200, pos)
}
\references{
Wittenburg, Bonk, Doschoris, Reyer (2019) Design of Experiments
  for Fine-Mapping Quantitative Trait Loci in Livestock Populations
  \url{https://doi.org/10.1101/2019.12.17.879106}
}
