% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sarar_regimes.R
\name{sarar_regimes}
\alias{sarar_regimes}
\alias{coef.sarar_regimes}
\alias{vcov.sarar_regimes}
\alias{print.sarar_regimes}
\alias{summary.sarar_regimes}
\alias{print.summary.sarar_regimes}
\title{Estimation of spatial regimes models}
\usage{
sarar_regimes(
  formula,
  data,
  listw,
  rgv,
  het,
  weps_rg = weps_rg,
  wy_rg = wy_rg,
  initial.value = NULL,
  verbose = FALSE,
  control,
  cl
)

\method{coef}{sarar_regimes}(object, ...)

\method{vcov}{sarar_regimes}(object, ...)

\method{print}{sarar_regimes}(x, digits = max(3, getOption("digits") - 3), ...)

\method{summary}{sarar_regimes}(object, ...)

\method{print}{summary.sarar_regimes}(x, digits = max(5, getOption("digits") - 3), ...)
}
\arguments{
\item{formula}{a symbolic description of the model of the form \code{y ~ x_f | x_v | wx | h_f | h_v | wh} where \code{y} is the dependent variable, \code{x_f} are the regressors that do not vary by regimes,  \code{x_v} are the regressors that vary by regimes, \code{wx} are the spatially lagged regressors, \code{h_f} are the instruments that do not vary by regimes,  \code{h_v} are the instruments that vary by regimes, \code{wh} are the spatially lagged instruments.}

\item{data}{the data of class \code{data.frame}.}

\item{listw}{a spatial weighting matrix of class \code{listw}, \code{matrix} or \code{Matrix}}

\item{rgv}{an object of class \code{formula} to identify the regime variables}

\item{het}{heteroskedastic variance-covariance matrix}

\item{weps_rg}{default FALSE, if TRUE the spatial error term varies by regimes (see details)}

\item{wy_rg}{default \code{wy_rg = FALSE}, the lagged dependent variable does not vary by regime (see details)}

\item{initial.value}{initial value for the spatial error parameter}

\item{verbose}{print a trace of the optimization}

\item{control}{argument for optimization}

\item{cl}{record calls}

\item{object}{an object of class sarar_regimes}

\item{...}{additional arguments}

\item{x}{an object of class sarar_regimes}

\item{digits}{number of digits}
}
\value{
An object of class \code{"sarar_regimes"}. A \code{list} of five elements. The first element of the \code{list} contains the estimation results. The other elements are needed for printing.
}
\description{
Estimation of spatial regimes models
}
\examples{
data("natreg")
data("ws_6")
form <-  HR90  ~ 0 | MA90 + PS90 +
RD90 + UE90 | 0 | 0 | MA90 + PS90 +
RD90 + FH90 + FP89 + GI89 | 0

form1 <-  HR90  ~ MA90 -1 |  PS90 +
RD90 + UE90 | 0 | MA90 -1 |  PS90 +
RD90 + FH90 + FP89 + GI89 | 0

split  <- ~ REGIONS

###############################
# Spatial SARAR regimes model #
###############################
mod6 <- spregimes(formula = form, data = natreg,
rgv = split, listw = ws_6, model = "sarar",
het = TRUE, wy_rg = TRUE, weps_rg = TRUE)
summary(mod6)
mod7 <- spregimes(formula = form, data = natreg,
rgv = split, listw = ws_6, model = "sarar",
het = TRUE, wy_rg = FALSE, weps_rg = FALSE)
summary(mod7)
mod8 <- spregimes(formula = form1, data = natreg,
rgv = split, listw = ws_6, model = "sarar",
het = TRUE, wy_rg = TRUE, weps_rg = FALSE)
summary(mod8)

}
