% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{checkCandidates}
\alias{checkCandidates}
\title{Candidates for misplacement}
\usage{
checkCandidates(final, win = 30, quant = 0.99)
}
\arguments{
\item{final}{table of results produced by \code{editraw} with pairwise
estimates of recombination rate between p SNPs within chromosome; minimum
required data frame with columns \code{SNP1}, \code{SNP2} and \code{theta}}

\item{win}{optional value for window size; default value 30}

\item{quant}{optional value; default value 0.99, see details}
}
\value{
vector of SNP indices for further verification
}
\description{
Search for SNPs with unusually large estimates of recombination
  rate
}
\details{
Markers with unusually large estimates of recombination rate to
  close SNPs are candidates for misplacements in the underlying assembly. The
  mean of recombination rate estimates with \code{win} subsequent or
  preceeding markers is calculated and those SNPs with mean value exceeding
  the \code{quant} quantile are denoted as candidates which have to be
  manually curated!
  This can be done, for instance, by visual inspection of a correlation plot
  containing estimates of recombination rate in a selected region.
}
\examples{
  ### test data
  data(targetregion)
  ### make list for paternal half-sib families
  hap <- makehaplist(daughterSire, hapSire)
  ### parameter estimates on a chromosome
  res <- hsrecombi(hap, genotype.chr, map.chr$SNP)
  ### post-processing to achieve final and valid set of estimates
  final <- editraw(res, map.chr)
  ### check for candidates of misplacement
  snp <- checkCandidates(final)
}
\references{
Hampel, A., Teuscher, F., Gomez-Raya, L., Doschoris, M. & Wittenburg, D.
   (2018) Estimation of recombination rate and maternal linkage
   disequilibrium in half-sibs. Frontiers in Genetics 9:186.
   \doi{10.3389/fgene.2018.00186}
}
