% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mc_manova_dispersion.R
\name{mc_manova_dispersion}
\alias{mc_manova_dispersion}
\title{MANOVA tables for dispersion components.}
\usage{
mc_manova_dispersion(object, p_var, names, verbose = TRUE)
}
\arguments{
\item{object}{An object of \code{mcglm} class.}

\item{p_var}{A vector of indices that indicate how the dispersion
parameters are related. Parameters with the same index are tested
together.}

\item{names}{Names to be shown in the table.}

\item{verbose}{a logical if TRUE print some information about the
tests performed. Default verbose = TRUE.}
}
\value{
Type III MANOVA table for dispersion components of mcglm
objects.
}
\description{
Performs Wald tests to generate multivariate analysis-of
-variance tables of the significance for the dispersion components
for model objects produced by mcglm.
}
\examples{

library(mcglm)
library(Matrix)
library(htmcglm)

data("soya", package = "mcglm")

form.grain <- grain ~ water * pot
form.seed <- seeds ~ water * pot

soya$viablepeasP <- soya$viablepeas / soya$totalpeas
form.peas <- viablepeasP ~ water * pot

Z0 <- mc_id(soya)
Z1 <- mc_mixed(~0 + factor(block), data = soya)

fit_joint <- mcglm(linear_pred = c(form.grain,
                                   form.seed,
                                   form.peas),
                   matrix_pred = list(c(Z0, Z1),
                                      c(Z0, Z1),
                                      c(Z0, Z1)),
                   link = c("identity",
                            "log",
                            "logit"),
                   variance = c("constant",
                                "tweedie",
                                "binomialP"),
                   Ntrial = list(NULL,
                                 NULL,
                                 soya$totalpeas),
                   power_fixed = c(TRUE,TRUE,TRUE),
                   data = soya)

mc_manova_dispersion(fit_joint,
               p_var = c(0,1),
               names = c('tau11', 'tau21'))

}
\seealso{
\code{mc_manova_I}, \code{mc_manova_II} and
\code{mc_manova_III}.
}
\author{
Lineu Alberto Cavazani de Freitas,
\email{lineuacf@gmail.com}
}
