% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_convert_hts2hdsm.R
\name{f_convert_hts2hdsm}
\alias{f_convert_hts2hdsm}
\title{Convert hts files in HDSM input format}
\usage{
f_convert_hts2hdsm(
  files,
  freqs,
  units,
  unit_factors,
  fileo = "calibration_data"
)
}
\arguments{
\item{files}{List of files}

\item{freqs}{List of time frequencies}

\item{units}{List of unit of the time-series}

\item{unit_factors}{List of unit of the time-series}

\item{fileo}{name of the output file (whithout extension)}
}
\value{
A text file to be used in the HDSM input section (calval).
}
\description{
Converter from hts files to HDSM input time series
}
\details{
The output file is stored in the directory of the first file in the files list.

freqs is a list with the time frequency of each selected time series. It can be "d" (daily),
"8d" (8 days) or "m" (monthly).

units is a list with the unit of each selected time series and unit_factors allow to modify the original
units of the hts files. If NA (default), factors are equal to 1.
}
\seealso{
\code{\link{f_convert_hdsm2hts}}
}
\author{
P. Chevallier - October 2017 - December 2021
}
