# This function uses the parameters and inusion dose PK model in the vLiverPBPK package to calculate a steady-state concentration comaprable with the values repoted in the Wetmore et al. (2012) and (2013) publications that were generated by SimCYP
# The function uses Monte Carlo methods to vary parameters and can return varies quantiles.
calc_mc_css <- function(chem.cas=NULL,
                            chem.name=NULL,
                            parameters=NULL,
                            daily.dose=1,
                            which.quantile=0.95,
                            species="Human",
                            output.units="mg/L",
                            suppress.messages=F,
                            censored.params=list(Funbound.plasma=list(cv=0.3,lod=0.01)),
                            vary.params=list(BW=0.3,Vliverc=0.3,Qgfrc=0.3,Qtotal.liverc=0.3,million.cells.per.gliver=0.3,Clint=0.3),
                            samples=1000,
                            return.samples=F)
{
  if(is.null(chem.cas) & is.null(chem.name) & is.null(parameters)) stop('Must specify chem.cas, chem.name, or parameters.')
  if (is.null(parameters)){
        parameters <- parameterize_steadystate(chem.cas=chem.cas,chem.name=chem.name,species=species)
      }else{
        name.list <- c("Clint","Funbound.plasma","Fhep.assay.correction","Qtotal.liverc","Qgfrc","BW","MW","million.cells.per.gliver","Vliverc","liver.density")
        if(!all(name.list %in% names(parameters)))stop(paste("Missing parameters:",paste(name.list[which(!name.list %in% names(parameters))],collapse=', '),".  Use parameters from parameterize_steadystate."))
      }
  
  out <- monte_carlo(params=parameters,censored.params=censored.params,which.quantile=which.quantile,cv.params=vary.params,samples=samples,model='3compartmentss',daily.dose=daily.dose,output.units=output.units,suppress.messages=T,return.samples=return.samples)
  
  if(!suppress.messages & !return.samples){
    if(is.null(chem.cas) & is.null(chem.name)){
      cat("Plasma concentration returned in",output.units,"units.\n")
    }else cat(paste(toupper(substr(species,1,1)),substr(species,2,nchar(species)),sep=''),"plasma concentration returned in",output.units,"units for",which.quantile,"quantile.\n") 
  }
  
    return(as.numeric(out))
}