% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tissue_mass_functions.R
\name{blood_mass_correct}
\alias{blood_mass_correct}
\title{Find average blood masses by age.}
\usage{
blood_mass_correct(blood_mass, age_months, age_years, gender, weight)
}
\arguments{
\item{blood_mass}{A vector of blood masses in kg to be replaced with
averages.}

\item{age_months}{A vector of ages in months.}

\item{age_years}{A vector of ages in years.}

\item{gender}{A vector of genders (either 'Male' or 'Female').}

\item{weight}{A vector of body weights in kg.}
}
\value{
A vector of blood masses in kg.
}
\description{
If blood mass from \code{\link{blood_weight}} is negative or very small,
then just default to the mean blood mass by age. (Geigy Scientific Tables,
7th ed.)
}
\references{
Geigy Pharmaceuticals, "Scientific Tables", 7th Edition, 
John Wiley and Sons (1970)

Ring, Caroline L., et al. "Identifying populations sensitive to
environmental chemicals by simulating toxicokinetic variability."
Environment International 106 (2017): 105-118
}
\author{
Caroline Ring
}
\keyword{httk-pop}
