% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{scr_h}
\alias{scr_h}
\title{KDE bandwidths for residual variability in serum creatinine}
\format{
A named list with 10 elements, each a numeric value. Each list element
 corresponds to, and is named for, one combination of NHANES sex categories
 (Male and Female) and NHANES race/ethnicity categories (Mexican American,
 Other Hispanic, Non-Hispanic White, Non-Hispanic Black, and Other).
}
\usage{
scr_h
}
\description{
Bandwidths used for a one-dimensional kernel density estimation of the
distribution of residual errors around smoothing spline fits of serum
creatinine vs. age  for NHANES respondents in each of ten combinations of sex
and race/ethnicity categories.
}
\details{
Each matrix is the standard deviation for a normal distribution: this is the
bandwidth to be used for a kernel density estimation (KDE) (using a normal
kernel) of the distribution of residual errors around smoothing spline fits of
serum creatinine vs. age for NHANES respondents in the specified sex and
race/ethnicity category. Optimal bandwidths were pre-calculated by doing the
smoothing spline fits, getting the residuals, then calling
\code{\link[ks]{kde}} on the residuals (which calls \code{\link[ks]{hpi}} to
compute the plug-in bandwidth).

Used by HTTK-Pop only in "virtual individuals" mode (i.e.
\code{\link{httkpop_generate}} with \code{method = "v"}), in
\code{\link{gen_serum_creatinine}}.
}
\references{
Ring, Caroline L., et al. "Identifying populations sensitive to
 environmental chemicals by simulating toxicokinetic variability."
 Environment International 106 (2017): 105-118
}
\author{
Caroline Ring
}
\keyword{data}
\keyword{httk-pop}
