% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_ma.R
\name{calc_ma}
\alias{calc_ma}
\title{Calculate the membrane affinity}
\usage{
calc_ma(
  chem.cas = NULL,
  chem.name = NULL,
  dtxsid = NULL,
  parameters = NULL,
  suppress.messages = FALSE
)
}
\arguments{
\item{chem.cas}{Chemical Abstract Services Registry Number (CAS-RN) -- if
parameters is not specified then the chemical must be identified by either
CAS, name, or DTXISD}

\item{chem.name}{Chemical name (spaces and capitalization ignored) --  if
parameters is not specified then the chemical must be identified by either
CAS, name, or DTXISD}

\item{dtxsid}{EPA's 'DSSTox Structure ID (\url{https://comptox.epa.gov/dashboard})
 -- if parameters is not specified then the chemical must be identified by 
either CAS, name, or DTXSIDs}

\item{parameters}{Parameters from the appropriate parameterization function
for the model indicated by argument model}

\item{suppress.messages}{Whether or not the output message is suppressed.}
}
\value{
A numeric fraction unpbound in plasma between zero and one
}
\description{
Membrane affinity (MA) is the membrane:water partition coefficient. MA
chacterizes chemical partitioning into membranes formed
from neutral phospholipids (\ifelse{html}{\out{K<sub>nPL</sub>}}{\eqn{K_{nPL}}}). 
Pearce et al. (2017) compared five different methods for predicting 
membrane affinity using measured data for 59 compounds. The method of
Yun and Edgington (2013) was identified as the best: 
\ifelse{html}{\out{MA = 10^(1.294 + 0.304 * log<sub>10</sub>(P<sub>ow</sub>)}}{\deqn{MA = 10^(1.294 + 0.304 * log_{10}(P_{ow}))}}
}
\references{
Pearce, Robert G., et al. "Evaluation and calibration of high-throughput 
predictions of chemical distribution to tissues." Journal of pharmacokinetics 
and pharmacodynamics 44.6 (2017): 549-565.

Yun, Y. E., and A. N. Edginton. "Correlation-based prediction of 
tissue-to-plasma partition coefficients using readily available input 
parameters." Xenobiotica 43.10 (2013): 839-852.
}
\author{
John Wambaugh
}
\keyword{in-vitro}
