% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/package.R
\name{http_problem}
\alias{http_problem}
\alias{bad_request}
\alias{unauthorized}
\alias{forbidden}
\alias{not_found}
\alias{conflict}
\alias{internal_server_error}
\title{Describe a Problem with an HTTP Request}
\usage{
http_problem(
  detail = NULL,
  status = 500L,
  type = NULL,
  title = NULL,
  instance = NULL,
  ...
)

bad_request(detail = NULL, instance = NULL, ...)

unauthorized(detail = NULL, instance = NULL, ...)

forbidden(detail = NULL, instance = NULL, ...)

not_found(detail = NULL, instance = NULL, ...)

conflict(detail = NULL, instance = NULL, ...)

internal_server_error(detail = NULL, instance = NULL, ...)
}
\arguments{
\item{detail}{A human-readable string giving more detail about the error,
if possible.}

\item{status}{The HTTP status code appropriate for the response.}

\item{type}{A URL pointing to human-readable documentation for this type of
problem. When \code{NULL}, the type is generated based on the status code; see
\code{\link[=http_problem_types]{http_problem_types()}} for a list of the defaults.}

\item{title}{A \href{https://tools.ietf.org/html/rfc7807#section-3.1}{"short, human-readable summary of the problem type"}.
When \code{NULL}, the title is generated based on the status code; see
\code{\link[=http_problem_types]{http_problem_types()}} for a list of the defaults.}

\item{instance}{A URL that identifies the specific occurrence of the
problem, if possible. When \code{NULL} this field is simply excluded.}

\item{...}{Additional fields added to the problem as \href{https://tools.ietf.org/html/rfc7807#section-3.2}{Extension Members}.}
}
\value{
An object of class \code{"http_problem"}, which has fields corresponding
to \href{https://tools.ietf.org/html/rfc7807#section-3.1}{an RFC 7807 Problem Details structure}.
}
\description{
\code{http_problem()} creates the "Problem Details" structure defined in
\href{https://tools.ietf.org/html/rfc7807}{RFC 7807}, used for reporting errors
from HTTP APIs in a standard way.

There are also helper methods for the most common HTTP problems:
HTTP 400 Bad Request, 404 Not Found, 401 Unauthorized, 403 Forbidden, 409
Conflict, and 500 Internal Server Error.
}
\examples{
body <- bad_request("Parameter 'id' must be a number.")
str(body)
}
\seealso{
\link{stop_for_http_problem} for issuing R errors with these structures.
}
