% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/server.R
\docType{data}
\name{PipeServer}
\alias{PipeServer}
\title{PipeServer class}
\description{
This class represents a server running one application that listens on a
named pipe.
}
\section{Methods}{


\describe{
  \item{\code{initialize(name, mask, app)}}{
    Create a new \code{PipeServer} object. \code{app} is an httpuv application
    object as described in \code{\link{startServer}}.
  }
  \item{\code{getName()}}{Return the value of \code{name} that was passed to
    \code{initialize()}.
  }
  \item{\code{getMask()}}{Return the value of \code{mask} that was passed to
    \code{initialize()}.
  }
  \item{\code{stop()}}{Stops a running server.}
  \item{\code{isRunning()}}{Returns TRUE if the server is currently running.}
  \item{\code{getStaticPaths()}}{Returns a list of \code{\link{staticPath}}
    objects for the server.
  }
  \item{\code{setStaticPath(..., .list = NULL)}}{Sets a static path for the
    current server. Each static path can be given as a named argument, or as
    an named item in \code{.list}. If there already exists a static path with
    the same name, it will be replaced.
  }
  \item{\code{removeStaticPath(path)}}{Removes a static path with the given
    name.
  }
  \item{\code{getStaticPathOptions()}}{Returns a list of default
    \code{staticPathOptions} for the current server. Each static path will
    use these options by default, but they can be overridden for each static
    path.
  }
  \item{\code{setStaticPathOption(..., .list = NULL)}}{Sets one or more
    static path options. Each option can be given as a named argument, or as
    a named item in \code{.list}.
  }
}
}

\seealso{
\code{\link{Server}} and \code{\link{WebServer}}.
}
\keyword{internal}
