% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/httpuv.R
\name{runServer}
\alias{runServer}
\title{Run a server}
\usage{
runServer(host, port, app, interruptIntervalMs = NULL)
}
\arguments{
\item{host}{A string that is a valid IPv4 or IPv6 address that is owned by
this server, which the application will listen on. \code{"0.0.0.0"}
represents all IPv4 addresses and \code{"::/0"} represents all IPv6
addresses.}

\item{port}{A number or integer that indicates the server port that should be
listened on. Note that on most Unix-like systems including Linux and Mac OS
X, port numbers smaller than 1025 require root privileges.}

\item{app}{A collection of functions that define your application. See
\code{\link{startServer}}.}

\item{interruptIntervalMs}{Deprecated (last used in httpuv 1.3.5).}
}
\description{
This is a convenience function that provides a simple way to call
\code{\link{startServer}}, \code{\link{service}}, and
\code{\link{stopServer}} in the correct sequence. It does not return unless
interrupted or an error occurs.
}
\details{
If you have multiple hosts and/or ports to listen on, call the individual
functions instead of \code{runServer}.
}
\examples{
\dontrun{
# A very basic application
runServer("0.0.0.0", 5000,
  list(
    call = function(req) {
      list(
        status = 200L,
        headers = list(
          'Content-Type' = 'text/html'
        ),
        body = "Hello world!"
      )
    }
  )
)
}
}
\seealso{
\code{\link{startServer}}, \code{\link{service}},
\code{\link{stopServer}}
}
