% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/headers.r
\name{content_type}
\alias{accept}
\alias{accept_json}
\alias{accept_xml}
\alias{content_type}
\alias{content_type_json}
\alias{content_type_xml}
\title{Set content-type and accept headers.}
\usage{
content_type(type)

content_type_json()

content_type_xml()

accept(type)

accept_json()

accept_xml()
}
\arguments{
\item{type}{A mime type or a file extension. If a file extension (i.e. starts
with \code{.}) will guess the mime type using \code{\link[mime]{guess_type}}.}
}
\description{
These are convenient wrappers aroud \code{\link{add_headers}}.
}
\details{
\code{accept_json}/\code{accept_xml} and
\code{content_type_json}/\code{content_type_xml} are useful shortcuts to
ask for json or xml responses or tell the server you are sending json/xml.
}
\examples{
GET("http://httpbin.org/headers")

GET("http://httpbin.org/headers", accept_json())
GET("http://httpbin.org/headers", accept("text/csv"))
GET("http://httpbin.org/headers", accept(".doc"))

GET("http://httpbin.org/headers", content_type_xml())
GET("http://httpbin.org/headers", content_type("text/csv"))
GET("http://httpbin.org/headers", content_type(".xml"))
}

