% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resp-stream.R, R/resp-stream-aws.R
\name{resp_stream_raw}
\alias{resp_stream_raw}
\alias{resp_stream_lines}
\alias{resp_stream_sse}
\alias{resp_stream_aws}
\alias{close.httr2_response}
\alias{resp_stream_is_complete}
\title{Read a streaming body a chunk at a time}
\usage{
resp_stream_raw(resp, kb = 32)

resp_stream_lines(resp, lines = 1, max_size = Inf, warn = TRUE)

resp_stream_sse(resp, max_size = Inf)

resp_stream_aws(resp, max_size = Inf)

\method{close}{httr2_response}(con, ...)

resp_stream_is_complete(resp)
}
\arguments{
\item{resp, con}{A streaming \link{response} created by \code{\link[=req_perform_connection]{req_perform_connection()}}.}

\item{kb}{How many kilobytes (1024 bytes) of data to read.}

\item{lines}{The maximum number of lines to return at once.}

\item{max_size}{The maximum number of bytes to buffer; once this number of
bytes has been exceeded without a line/event boundary, an error is thrown.}

\item{warn}{Like \code{\link[=readLines]{readLines()}}: warn if the connection ends without a final
EOL.}

\item{...}{Not used; included for compatibility with generic.}
}
\value{
\itemize{
\item \code{resp_stream_raw()}: a raw vector.
\item \code{resp_stream_lines()}: a character vector.
\item \code{resp_stream_sse()}: a list with components \code{type}, \code{data}, and \code{id}
\item \code{resp_stream_aws()}: a list with components \code{headers} and \code{body}.
\code{body} will be automatically parsed if the event contents a \verb{:content-type}
header with \code{application/json}.
}

\code{resp_stream_sse()} and \code{resp_stream_aws()} will return \code{NULL} to signal that
the end of the stream has been reached or, if in nonblocking mode, that
no event is currently available.
}
\description{
\itemize{
\item \code{resp_stream_raw()} retrieves bytes (\code{raw} vectors).
\item \code{resp_stream_lines()} retrieves lines of text (\code{character} vectors).
\item \code{resp_stream_sse()} retrieves a single \href{https://developer.mozilla.org/en-US/docs/Web/API/Server-sent_events/Using_server-sent_events}{server-sent event}.
\item \code{resp_stream_aws()} retrieves a single event from an AWS stream
(i.e. mime type `application/vnd.amazon.eventstream``).
}

Use \code{resp_stream_is_complete()} to determine if there is further data
waiting on the stream.
}
\examples{
req <- request(example_url()) |>
  req_template("GET /stream/:n", n = 5)

con <- req |> req_perform_connection()
while (!resp_stream_is_complete(con)) {
  lines <- con |> resp_stream_lines(2)
  cat(length(lines), " lines received\n", sep = "")
}
close(con)

# You can also see what's happening by setting verbosity
con <- req |> req_perform_connection(verbosity = 2)
while (!resp_stream_is_complete(con)) {
  lines <- con |> resp_stream_lines(2)
}
close(con)
}
