% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hubeau.R
\docType{package}
\name{hubeau}
\alias{hubeau}
\title{hubeau: A package for retrieving data on the French databases on water 'Hub'Eau'}
\description{
The 'hubeau' package provides functions for 'Hub'Eau' APIs and their related endpoints.
These functions are named as follow: \verb{hubeau::get_[API]_[endpoint]}.

Currently available APIs and related endpoints are listed below.
\subsection{API "Ecoulement des cours d'eau"}{

API documentation: \url{https://hubeau.eaufrance.fr/page/api-ecoulement}

Available functions:
\itemize{
\item \code{\link[=get_ecoulement_stations]{get_ecoulement_stations()}}: site data and locations
\item \code{\link[=get_ecoulement_observations]{get_ecoulement_observations()}}: flow observations collected during campaigns
\item \code{\link[=get_ecoulement_campagnes]{get_ecoulement_campagnes()}}: observation campaign information
}
}

\subsection{API "Hydrométrie"}{

API documentation: \url{https://hubeau.eaufrance.fr/page/api-hydrometrie}

Available functions:
\itemize{
\item \code{\link[=get_hydrometrie_sites]{get_hydrometrie_sites()}}: hydrometry sites (can contain several stations)
\item \code{\link[=get_hydrometrie_stations]{get_hydrometrie_stations()}}: hydrometry stations
\item \code{\link[=get_hydrometrie_observations_tr]{get_hydrometrie_observations_tr()}}: hydrometry water level and discharge time series
\item \code{\link[=get_hydrometrie_obs_elab]{get_hydrometrie_obs_elab()}}: hydrometric elaborate observations (daily/monthly mean flow)
}
}

\subsection{API "Indicateurs des services"}{

API documentation: \url{https://hubeau.eaufrance.fr/page/api-indicateurs-services}

Available functions:
\itemize{
\item \code{\link[=get_indicateurs_services_communes]{get_indicateurs_services_communes()}}: performance indicators by commune
\item \code{\link[=get_indicateurs_services_indicateurs]{get_indicateurs_services_indicateurs()}}: performance indicators by indicator
\item \code{\link[=get_indicateurs_services_services]{get_indicateurs_services_services()}}: performance indicators by commune for each service
}
}

\subsection{API "Piézométrie"}{

API documentation: \url{https://hubeau.eaufrance.fr/page/api-piezometrie}

Available functions:
\itemize{
\item \code{\link[=get_niveaux_nappes_chroniques]{get_niveaux_nappes_chroniques()}}: archived time series of piezometric stations
\item \code{\link[=get_niveaux_nappes_chroniques_tr]{get_niveaux_nappes_chroniques_tr()}}: real-time time series of piezometric stations
\item \code{\link[=get_niveaux_nappes_stations]{get_niveaux_nappes_stations()}}: piezometric stations
}
}

\subsection{API "Poisson"}{

API documentation: \url{https://hubeau.eaufrance.fr/page/api-poisson}

Available function:
\itemize{
\item \code{\link[=get_poisson_observations]{get_poisson_observations()}}: scientific fishery observations
}
}

\subsection{API "Prélèvements en eau"}{

API documentation: \url{https://hubeau.eaufrance.fr/page/api-prelevements-eau}

Available functions:
\itemize{
\item \code{\link[=get_prelevements_chroniques]{get_prelevements_chroniques()}}: time series of annual withdrawn volumes by device
\item \code{\link[=get_prelevements_ouvrages]{get_prelevements_ouvrages()}}: withdrawal devices (can contain several withdrawal points)
\item \code{\link[=get_prelevements_points_prelevement]{get_prelevements_points_prelevement()}}: withdrawal points
}
}
}
