% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/humarray.R
\name{get.telomere.locs}
\alias{get.telomere.locs}
\title{Derive Telomere locations across the genome}
\usage{
get.telomere.locs(dir = NULL, kb = 10, build = NULL, bioC = TRUE,
  GRanges = TRUE, text = FALSE, autosomes = FALSE, mito.zeros = FALSE)
}
\arguments{
\item{dir}{character, location to store file with the this annotation.
If NULL then getOption("save.annot.in.current")>=1 will result in
this file being stored in the current directory, or if <=0, then this file will not
be stored.}

\item{kb}{The number of base pairs at the start and end of a chromosome that are defined as
belonging to the telomere can be a little arbitrary. This argument allows specification
of whatever threshold is required.}

\item{build}{string, currently 'hg18' or 'hg19' to specify which annotation version to use. 
Default is build-36/hg-18. Will also accept integers 36,37 as alternative arguments.}

\item{bioC}{logical, whether to return the annotation as a ranged S4 object (GRanges or
RangedData), or as a data.frame}

\item{GRanges}{logical, whether to return a GRanges object, or FALSE to return RangedData}

\item{text}{logical, whether to return locations as a text vector of the form: chrN:xxxx-xxxx}

\item{autosomes}{logical, if TRUE, only return results for autosomes, if FALSE, also include
X and Y.}

\item{mito.zeros}{logical, Mitochondria have no telomeres (are circular) but for some purposes you
might want zero values in order to match with other annotation that includes all chromosomes and MT.
TRUE adds zeros for chrMT, and FALSE excludes chrMT.}
}
\value{
Returns a text vector, GRanges or RangedData object, depending on input parameters. Contained
will be telomere chromosome and start and end positions.
}
\description{
Returns the locations of telomeres in the human genome, for a given build, as
a list by chromosome, text vector, or GRanges/RangedData object.
}
\examples{
setwd(tempdir())
get.telomere.locs()
get.telomere.locs(bioC=FALSE)
get.telomere.locs(text=TRUE)
}

