% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/humarray.R
\name{ranged.to.txt}
\alias{ranged.to.txt}
\title{Convert GRanges/RangedData to chr:pos1-pos2 vector}
\usage{
ranged.to.txt(ranges)
}
\arguments{
\item{ranges}{A RangedData or GRanges object}
}
\value{
a text vector of the same length as 'ranges' with notation as described above
representing each position in the 'ranges' object
}
\description{
Takes a RangedData or GRanged object from some annotation lookup functions and converts to standard text
positions, such as what you might see on the UCSC genome browser, such as 
chr1:10,000,234-11,000,567 for a range, or chrX:234,432 for a SNP. Useful for printing
messages, concatenating positions to a single vector, or creating queries for databastes.
}
\examples{
ranged.to.txt(rranges())
}
\seealso{
\code{\link{convert.textpos.to.data}}
}

