% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/humarray.R
\name{Gene.pos}
\alias{Gene.pos}
\title{Find the gene(s) overlapping a chromosome location}
\usage{
Gene.pos(chr = NA, pos = NA, start = NA, end = NA, ranges = NULL,
  build = NULL, dir = NULL, bioC = FALSE, one.to.one = TRUE)
}
\arguments{
\item{chr}{character, an optional vector of chromosomes to combine with 'pos' or 'start'+'end'
(enter in ...) to describe positions to retrieve the possible overlapping gene(s)}

\item{pos}{integer, an optional vector of chromosome positions (for SNPs), no need to enter
start or end if this is entered, and vice-versa}

\item{start}{integer, an optional vector of start points for chromosome ranges}

\item{end}{integer, an optional vector of end points for chromosome ranges}

\item{ranges}{optional GRanges or RangedData object describing positions for which we want genes,
removing the need to enter chr, pos, start or end}

\item{build}{character, "hg18" or "hg19" (or 36/37) to show which reference to retrieve. The 
default when build is NULL is to use the build from the current ChipInfo annotation}

\item{dir}{character, 'dir' is the location to download gene annotation information to; if left as
NULL, depending on the value of getOption("save.annot.in.current"), the annotation will either
be saved in the working directory to speed-up subsequent lookups, or deleted after use.}

\item{bioC}{logical, if true then return position information as a GRanges object, or
RangedData if 'ranges' is RangedData, else a data.frame}

\item{one.to.one}{logical, whether to concatenate multiple hits for the same range into one result,
or spread the result over multiple lines, one for each gene overlapped}
}
\value{
Returns a set of genes separated by semicolons (if more than one) for each range entered.
If bioC=TRUE, returns the equivalent as a GRanges object, unless a RangedData object was used
for the ranges parameter, in which case a RangedData object would be returned. If one.to.one is
FALSE, then instead of concatenating multiple genes into one line per range, each is listed 
separately as a new row, with an index added to correspond to the original input order of ranges,
if bioC=TRUE; or just adds additional elements to the resulting vector if bioC=FALSE.
}
\description{
Allows retrieval of genes intersected by a chromosome and position, which can be entered
using chr, pos/start/end vectors, or a RangedData or GRanges object
}
\examples{
\donttest{
setwd(tempdir())
Gene.pos(chr=6, start=31459636, end=31462760)
Gene.pos(chr=22, pos=3452345) # no gene here
Gene.pos(Chr("rs689"),Pos("rs689")) # combine with Chr() and Pos() to find gene(s) for SNP rs689
Gene.pos(chr=1,start=114000000,end=115000000,build="hg19") # multiple genes in range
Gene.pos(chr=1,start=114000000,end=115000000,one.to.one=FALSE) # list separately
ii <- Pos.gene(c("CTLA4","PTPN22"))
Gene.pos(ii$chr,ii$start,ii$end,bioC=FALSE) # returns same genes inputted on line above
}
}
\seealso{
\code{\link{Chr}}, \code{\link{Pos}}, \code{\link{Pos.band}}, \code{\link{Band}}, 
\code{\link{Band.gene}}, \code{\link{Band.pos}}, \code{\link{Gene.pos}}
}
\author{
Nicholas Cooper \email{nick.cooper@cimr.cam.ac.uk}
}
