% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weight2rows.R
\name{weight2rows}
\alias{weight2rows}
\title{Expand a weighted data frame to an equivalent unweighted}
\usage{
weight2rows(DT, weight.var)
}
\arguments{
\item{DT}{A \code{data.table}. Will be converted to one if possible.}

\item{weight.var}{Variable in \code{DT} to be used as weights.}
}
\value{
\code{DT} but with the number of rows expanded to \code{sum(DT[[weight.var]])} to reflect the weighting.
}
\description{
Expand a weighted data frame to an equivalent unweighted
}
\examples{

library(data.table)
DT <- data.table(x = 1:5, y = c(1, 1, 1, 1, 2))
weight2rows(DT, "y")

}
