% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hull.R
\name{ahull}
\alias{ahull}
\title{Maximum area given x and y coordinates}
\usage{
ahull(
  DT,
  x = DT$x,
  y = DT$y,
  minH = 0,
  minW = 0,
  maximize = "area",
  incl_negative = FALSE
)
}
\arguments{
\item{DT, x, y}{Coordinates of a curve containing a rectangle. 
Either as a list, \code{DT}, containing columns \code{x} and \code{y}.}

\item{minH}{The minimum height of the rectangles.}

\item{minW}{The minimum width of the rectangles.}

\item{maximize}{How the rectangle should be selected. Currently, only \code{"area"} supported.}

\item{incl_negative}{Should areas below the x-axis be considered?}
}
\value{
A \code{data.table}: The coordinates of a rectangle, from (0, 0), (1, 0), (1, 1), (0, 1), south-west clockwise, 
that is contained within the area of the chart for positive values only.
}
\description{
Present since \code{hutils 1.2.0}.
}
\examples{
ahull(, c(0, 1, 2, 3, 4), c(0, 1, 2, 0, 0))

}
