% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/attributes.R
\name{caption_pos}
\alias{caption_pos}
\alias{caption_pos<-}
\alias{set_caption_pos}
\alias{caption_pos.huxtable}
\alias{caption_pos<-.huxtable}
\title{Get or Set Caption Position}
\usage{
caption_pos(ht)
caption_pos(ht) <- value
set_caption_pos(ht, value)
}
\arguments{
\item{ht}{A huxtable.}

\item{value}{A length-one character vector which can be 'top', 'bottom' or \code{NA} for the default.}
}
\value{
For \code{caption_pos}, the \code{caption_pos} attribute.
For \code{set_caption_pos}, the \code{ht} object.
}
\description{
Functions to get or set the table-level caption position property of a huxtable.
}
\examples{

ht <- huxtable(a = 1:3, b = 1:3)
caption_pos(ht) <-  'top'
caption_pos(ht)

}
\seealso{
\code{\link{caption}}
}
